/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.datamodels.v2_1;

import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.datamodels.v2_1.DataFilter;

public class ScrolledData
extends DataFilter {
    int offset_ = 0;
    int range_;
    int maxOffset_;

    public ScrolledData(DataModel data, int range) {
        super(data);
        this.range_ = range;
        int count = data.getColumnCount();
        if (range > count) {
            this.range_ = count;
        }
        this.maxOffset_ = count - this.range_;
    }

    public DataModel getFilteredData() {
        return this.data;
    }

    public void setOffset(int offset) {
        if (offset <= this.maxOffset_) {
            this.offset_ = offset;
        }
        this.dataUpdate();
    }

    public void setRange(int range) {
        this.range_ = range;
        int count = this.data.getColumnCount();
        if (range > count) {
            this.range_ = count;
        }
        this.maxOffset_ = count - this.range_;
        if (this.offset_ > this.maxOffset_) {
            this.offset_ = this.maxOffset_;
        }
        this.dataUpdate();
    }

    public double getValue(int row, int column) {
        return this.data.getValue(row, column + this.offset_);
    }

    public String getColumnLabel(int column) {
        return this.data.getColumnLabel(column + this.offset_);
    }

    public int getColumnCount() {
        return this.range_;
    }
}

